///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Global Variables and Initializations
//
//////////////////////////////////////////////////////////////////////////////

function AddKeyboardEventListener()
{
if (is_ie)
	document.onkeyup = function() {KeyPressHandler(event);}
else if (is_nav)
	document.onkeypress=function(event) {KeyPressHandler(event);}
}

function IgnoreEvent()
{
if (is_ie)
	event.returnValue = false;
else if (is_nav)
	return false;
}

function KeyPressHandler(event)
{
	if (event.shiftKey && event.ctrlKey)
		{
		   NQWClearActiveMenu();
		  //alert(event.keyCode);
		  var keyCode = event.keyCode;
		  //putting this code in due to mozilla bug
         if (is_nav && keyCode == 0)
		      keyCode = event.charCode;

			switch (keyCode)
				{
				case 113: {DashboardLinksHotKeyPressed(event);} //F2
					break;
				case 114: {PageTabsHotKeyPressed(event);} //F3
					break;
				case 119: {NextElementHotKeyPressed(event);} //F8
					break;
				case 118: {PreviousElementHotKeyPressed(event);} //F7
					break;
				case 83: {NextSectionHotKeyPressed(event);}  //S
					break;
				case 85: {PreviousSectionHotKeyPressed(event);} //U
					break;
//				case 189: {CtrlShiftTBD_handler();}
//					break;
				default: {}
					break;
				}

			event.returnValue = false;
		}

//DO Conditional for NAVIGATOR
// if(is_nav && ...event.modifiers  //HAVE TO FIGURE HOW IT WORKS ON NAVIGATOR
//	{
//		switch (event.which)
//			{
//			case 84: ...
//				break;
//			default: {}
//				break;
//			}
//
//		return false;
//	}

}

function CtrlShiftTBD_handler(event)
{
   var welcome=document.getElementById("WelcomeLinkSpan");
   if (welcome)
   {
      var links = welcome.getElementsByTagName("a");
      if (links.length > 0)
      {
         links[0].focus();
      }
   }
}

function PageTabsHotKeyPressed(event)
{
	if (document.getElementById("TabsTable").rows[0].cells.length && document.getElementById("TabsTable").rows[0].cells[1].firstChild.outerHTML!="<!-- CHTMLSpan -->")
		document.getElementById("TabsTable").rows[0].cells[1].firstChild.focus();
	else if (document.getElementById("HighTab"))
		document.getElementById("HighTab").focus();
}

function DashboardLinksHotKeyPressed(event)
{
//Focus on My Dashboard Link
	var dashboardLinks=document.getElementsByName("DashboardBannerLink");
   if (dashboardLinks.length > 0)
   {
      try
      {
         dashboardLinks[0].focus();
      }
      catch (e)
      {
         NQWPopupMenu(event,saw.getParentElement(dashboardLinks[0]).getAttribute("id"));
         dashboardLinks[0].focus();
      }
   }
}

var currentElementNumber=null;
function NextElementHotKeyPressed(event)
{
	if (currentSectionNumber==null)
		currentSectionNumber=0;

	var sections=document.getElementsByName("SectionTableTitle");
	var section;
	if (sections.length)
   	section = saw.getParentElement(saw.getParentElement(sections[currentSectionNumber]));
   else
      section = document.getElementById("GoResult");

   if (!section)
      return;

	var links;
   var ments = new Array();
	var allLinks=section.getElementsByTagName("A");
	for (var i=0; i< allLinks.length; i++)
	{
	   if (allLinks[i].getAttribute("name") == "SectionElements")
	   {
         ments[ments.length] = allLinks[i];
      }
	}

   if (!links)
	   links = new Array();

	var elements= new Array();

   if (!ments.length)
	   elements[0] = ments;

   for (var i=elements.length; i<(ments.length+links.length); i++)
	{
		if (i<ments.length)
			elements[i]=ments[i];
		else
			elements[i]=links[i-ments.length];
	}

	if (currentElementNumber!=null)
	{
		currentElementNumber++;
		if (currentElementNumber>(elements.length-1))
			currentElementNumber=0;
	}
	else
		currentElementNumber=0;

	try
	{
	   if (elements[currentElementNumber].name == "ReportLinkMenu")
	   {
         currentElementNumber++;
         if (currentElementNumber>(elements.length-1))
            currentElementNumber=0;
	   }
	}
	catch (e)
	{
	}

   try
   {
      if (elements[currentElementNumber].className == "NQWMenuItem")
      {
         NQWClearActiveMenu();
         NQWPopupMenu(event,saw.getParentElement(elements[currentElementNumber]).getAttribute("id"));
      }
      elements[currentElementNumber].focus();
   }
   catch(e)
   {
   }
}

function PreviousElementHotKeyPressed(event)
{
	if (currentSectionNumber==null)
		currentSectionNumber=0;
	var sections=document.getElementsByName("SectionTableTitle");
	var section;
	if (sections.length)
   	section = sections[currentSectionNumber].parentElement.parentElement;
   else
      section = document.getElementById("GoResult");

   if (!section)
      return;

	var links;
   var ments = new Array();
	var allLinks=section.getElementsByTagName("A");
	for (var i=0; i< allLinks.length; i++)
	   if (allLinks[i].getAttribute("name") == "SectionElements")
         ments[ments.length] = allLinks[i];

	if (!links)
	   links = new Array();

	var elements= new Array();
   if (!ments.length)
	   elements[0] = ments;

	for (var i=0; i<(ments.length+links.length); i++)
		{
			if (i<ments.length)
				elements[i]=ments[i];
			else
				elements[i]=links[i-ments.length];
		}

	if (currentElementNumber!=null)
		{
			currentElementNumber--;
			if (currentElementNumber<0)
				currentElementNumber=elements.length-1;
		}
	else
		currentElementNumber=elements.length-1;

	try
	{
	   if (elements[currentElementNumber].name == "ReportLinkMenu")
	   {
         currentElementNumber--;
			if (currentElementNumber<0)
				currentElementNumber=elements.length-1;
	   }
	}
	catch (e)
	{
	}

   try
   {
      if (elements[currentElementNumber].className == "NQWMenuItem")
      {
         NQWClearActiveMenu();
         NQWPopupMenu(event,elements[currentElementNumber].parentElement.getAttribute("id"));
      }

      elements[currentElementNumber].focus();
   }
   catch(e)
   {
   }
}

var currentSectionNumber=null;
function PreviousSectionHotKeyPressed(event)
{
	var sections=document.getElementsByName("SectionTableTitle");
   if (sections.length)
   {
	   currentElementNumber=null;

	   if (currentSectionNumber!=null)
		   {
			   currentSectionNumber--;
			   if (currentSectionNumber<0)
				   currentSectionNumber=sections.length-1;
		   }
	   else
		   currentSectionNumber=sections.length-1;

      var section = sections[currentSectionNumber];
      
      if (!section)
         return;
      
      window.scrollTo(saw.calcAbsoluteLeft(section), saw.calcAbsoluteTop(section));
	   section.focus();
	}
	else
	   PreviousElementHotKeyPressed(event);
}

function NextSectionHotKeyPressed(event)
{
	var sections=document.getElementsByName("SectionTableTitle");
	if (sections.length)
	{
	   currentElementNumber=null;

	   if (currentSectionNumber!=null)
		   {
			   currentSectionNumber++;
			   if (currentSectionNumber>(sections.length-1))
				   currentSectionNumber=0;
		   }
	   else
		   currentSectionNumber=0;

      var section = sections[currentSectionNumber];
      
      if (!section)
         return;
      
      window.scrollTo(saw.calcAbsoluteLeft(section), saw.calcAbsoluteTop(section));
	   section.focus();
	}
	else
	   NextElementHotKeyPressed();
}

AddKeyboardEventListener();

function ShowProperties(Obj)
{
 var names='';
 for (var name in Obj)
 var tRE = new RegExp("\\bon");
	if (!(tRE.test(name))) names+=name+"  ";
 for (var name in Obj)
	if ((tRE.test(name))) names+=name+"  ";

 alert("Properties:  "+names);
}

function BannerInitPortalMenu(event, tMenu)
{
	var tLayerCell = NQWGetContainer(saw.getEventTarget(event), 'TD');

	tMenu.tLayerCell = tLayerCell;
}

saw.bookmarkURL = "";

function linkToPage(bInlineDrill, bGetBookmarkOnly)
{
    var linkForm = document.createElement("form");
     
    var viewForm = document.forms["ViewForm"];
    saw.addHiddenInput(linkForm, "PortalPath", viewForm.PortalPath.value);
    saw.addHiddenInput(linkForm, "Page", viewForm.Page.value);
    
    if(bGetBookmarkOnly)
        saw.addHiddenInput(linkForm, "GetBookmarkOnly", "true");
    
    if(bInlineDrill)
    {
        var viewStateDiv = document.getElementById("idViewStateDiv");
        saw.addHiddenInput(linkForm, "ViewState", viewStateDiv.getAttribute("stateID"));
        
        var pageIDDiv = document.getElementById("idPageID");
        saw.addHiddenInput(linkForm, "PageIdentifier", pageIDDiv.getAttribute("pageID"));
    }
    else
    {
        saw.addHiddenInput(linkForm, "ViewState", viewForm.ViewState.value);
        var statePathDiv = document.getElementById("idStatePathDiv");
        saw.addHiddenInput(linkForm, "ViewID", statePathDiv.getAttribute("statePath"));
    }
   
    saw.bookmarkURL = "";
    saw.clearActiveMenu();
    var req = new sawr.serverRequest("CreateBookmark", GotoBookmark);
    var conn = new sawr.xhrConnection(req);
    conn.postForm(linkForm);
    return false;  
}

function GotoBookmark(data)
{
  if(data.tXML)
  {
    var tBookmark = data.tXML.firstChild;
    var id = tBookmark.getAttribute("id");
    var bInlineDrill = (tBookmark.getAttribute("inlineDrill") == "true");
    var bGetBookmarkOnly = (tBookmark.getAttribute("getBookmarkOnly") == "true");
    
    var href = "";
    var viewForm = document.forms["ViewForm"];
    
    if(bInlineDrill)
     {
        href += saw.commandToURL("Dashboard");
        href += "&PortalPath=" + saw.encodeURIComponent(viewForm.PortalPath.value);
        href += "&Page=" + saw.encodeURIComponent(viewForm.Page.value);
        
        var pageIDDiv = document.getElementById("idPageID");
        href += "&PageIdentifier=" + saw.encodeURIComponent(pageIDDiv.getAttribute("pageID"));
        href += "&BookmarkState=" + saw.encodeURIComponent(id);
     }
     else
     {
        href = saw.commandToURL("PortalGo");
        href += "&PortalPath=" + saw.encodeURIComponent(viewForm.PortalPath.value);
        href += "&Page=" + saw.encodeURIComponent(viewForm.Page.value);
        
        var statePathDiv = document.getElementById("idStatePathDiv");
        href += "&ViewID=" + saw.encodeURIComponent(statePathDiv.getAttribute("statePath"));
        href += "&BookmarkState=" + saw.encodeURIComponent(id);
        href += "&Done=" + saw.encodeURIComponent(viewForm.Done.value);
     }
     
     if(bGetBookmarkOnly)
        saw.bookmarkURL = href;
     else
        location.href = href;
  }
}

function GetPURL()
{
    var href = saw.commandToURL("Dashboard");
    var viewForm = document.forms["ViewForm"];
    if(viewForm)
    {
        href += "&PortalPath=" + saw.encodeURIComponent(viewForm.PortalPath.value);
        href += "&Page=" + saw.encodeURIComponent(viewForm.Page.value);
        href += "&Action=Navigate";
    }

    if(typeof GFPGetPromptValues2 != "undefined")
        href += GFPGetPromptValues2();
        
    return href;
}

function GotoPURL()
{
  location.href = GetPURL();
}

function SetHint()
{
    saw.clearActiveMenu();
    var req = new sawr.serverRequest("CreateBookmark", GotoPURL);
    var conn = new sawr.xhrConnection(req);
    return conn.get();
}