
//This file is for ST project 23645 - copy xml to clipboard feature
function copyXMLTemplate(sReport, sFlashCLSID, sFlashCodebase, sFlashPluginsPage)
{
   // ST Project 23645 - this function will be used to call the constructor  CopyToClipboard()
   // inside the file CopyToClipboard.as
   // use both object tag and embed tag for supporting different browsers  
   var sEncodedStr = saw.encodeHTML(saw.encodeURIComponent(sReport));
   var reportInfo = '<object classid="' + sFlashCLSID + '" \n'                           +
                       'id="copyXMLMovie" width="0" height="0" \n'                       +
                       'codebase="' + sFlashCodebase + '"> \n'                           +
                    '<param name="movie" value="' + saw_clipboard_SWF_file_ + '" /> \n'  +
                    '<param name="quality" value="high" /> \n'                           +
                    '<param name="bgcolor" value="#869ca7" /> \n'                        +
                    '<param name="flashvars" value="report=' + sEncodedStr + '" /> \n'   +
                    '<param name="allowScriptAccess" value="sameDomain" /> \n'               +
                    '<embed src="' + saw_clipboard_SWF_file_ + '" quality="high" bgcolor="#869ca7" \n' +
                           'width="0" height="0" name="copyXMLMovie" align="middle" \n'  +
                           'play="true" \n'                                              +
                           'loop="false" \n'                                             +
                           'allowScriptAccess="sameDomain" \n'                               +
                           'flashvars="report=' + sEncodedStr + '" \n'                   +
                           'type="application/x-shockwave-flash" \n'                     +
                           'pluginspage="' + sFlashPluginsPage + '"> \n'                 +
                    '</embed> \n'                                                        +
                    '</object>  \n';
    return reportInfo;
}       

// CopyXML To Clipboard
function copyXMLToClipboard(sSearchId, sViewName, sFlashCLSID, sFlashCodebase, sFlashPluginsPage, sIncludeAllReports)
{  
   // Callback function definition
   fCallBack = function(tResponse)
   {    
      var tXml =  tResponse.getXML();
      var tReportsXML = tXml.selectSingleNode('saw:report');
      var sReport = saw.getXmlText(tReportsXML);
      
      //debug usage
      //if (is_ie)
         //window.clipboardData.setData('text', sReport);

      var flashCopyId = 'flashCopyId';
      var bLoaded = document.getElementById(flashCopyId);
      
      if(!bLoaded) 
      {
         var flashCopyDiv = document.createElement('div');
         flashCopyDiv.id = flashCopyId;
         document.body.appendChild(flashCopyDiv);
      }
      
      if (document.getElementById(flashCopyId).innerHTML != '')
         document.getElementById(flashCopyId).innerHTML = '';
        
      var reportInfo = copyXMLTemplate(sReport, sFlashCLSID, sFlashCodebase, sFlashPluginsPage);
      document.getElementById(flashCopyId).innerHTML = reportInfo;
   }
   
   // AJAX call to get the report XML data
   var req = new sawr.serverRequest("getReportXML", fCallBack);
   req.addArg ("SearchID", sSearchId);
   req.addArg ("ViewName", sViewName);
   req.addArg ("IncludeAllReports", sIncludeAllReports);
   var conn = new sawr.xhrConnection(req);
   conn.post();
}

//This function will be called in the actionscript file, "copyToClipBoard.as". The above two functions is for supporting 
//flash version 8, the following function is for supporting flash version 9 and 10.
copyToClipBoard = function(sSearchId, sViewName)
{
   var sIncludeAllReports = false;

   // AJAX call to get the report XML data
   var tData = null;
   var req = new sawr.serverRequest("getReportXML", function(tResponse){tData = tResponse;});
   req.addArg ("SearchID", sSearchId);
   req.addArg ("ViewName", sViewName);
   req.addArg ("IncludeAllReports", sIncludeAllReports);
   var conn = new sawr.xhrConnection(req);
   conn.setSync(true); 
   conn.post();
   
   var sReport = null;
   if (tData)
   {
      var tXml =  tData.getXML();
      var tReportsXML = tXml.selectSingleNode('saw:report');
      var sReport = saw.getXmlText(tReportsXML);
      //keep the following codes for future reference
      //var sEncodedStr = saw.encodeHTML(saw.encodeURIComponent(sReport));        
      //return sEncodedStr;
   }
   return sReport;
}