///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Drill Info globals

var kDrillInfoDrillOn = 1;
var kDrillInfoFilterOn = 2;

//String Replacement function
function StringReplace(str,substrReplaced,substrReplacing)
{
   return str.split(substrReplaced).join(substrReplacing);
}

///////////////////////////////////////////////////////////////////////////////
// Drill Info object & helpers

function DrillInfo_EncodeImpl(vArray, bEscape)
{
   var sEncoded = "";

   for (var i = 0; i < vArray.length; ++i)
   {
      var tObj = vArray[i];

      if (tObj != null)
      {
         // escape value & append
         var sTmp = tObj.toString();

         if (bEscape)
         {
            // first escape slashes
            sTmp = StringReplace(sTmp,"\\","\\\\");
            // then do tildes
            sTmp = StringReplace(sTmp,"~","\\~");

            // then put in
            sEncoded += sTmp;
         }
         else
            sEncoded += sTmp;

         // separator
         if ((i + 1) < vArray.length)
            sEncoded += "~";
      }
   }


   return sEncoded;
}

function DrillInfo_EncodeValues()
{
   return DrillInfo_EncodeImpl(this.values,true);
}

function DrillInfo_EncodeQueryColumns()
{
   return DrillInfo_EncodeImpl(this.columns,false);
}

function DrillInfo_EncodeVirtColumnsImpl(vArray,vCols)
{
   var sEncoded = "";

   var nVirtCol = 0;

   for (var i = 0; i < vArray.length; ++i)
   {
      if (vArray[i] == true)
      {
         sEncoded += nVirtCol.toString();

         // separator
         if ((i + 1) < vArray.length)
            sEncoded += "~";
      }

      if (vCols[i] != null)
         ++nVirtCol;
   }

   return sEncoded;
}

function DrillInfo_EncodeDrillColumns()
{
   return DrillInfo_EncodeVirtColumnsImpl(this.drillCols,this.columns);
}

function DrillInfo_EncodeFilterColumns()
{
   return DrillInfo_EncodeVirtColumnsImpl(this.filterCols,this.columns);
}

function DrillInfo_EncodePivotStartingPage()
{
   if (this.pivotAllPages)
      return "allpages";
   else
      return "notallpages";
}

function DrillInfo_AddValue(nCol,sValue,eWhat)
{
   if(sValue == null)
   {
      this.values[nCol] = '*NQ_NULL*';
   } else
   {
      this.values[nCol] = sValue.toString(); // make sure we save string value
   }

   this.AddColumn(nCol,eWhat);

}

function DrillInfo_AddColumn(nCol,eWhat)
{
   this.columns[nCol] = nCol;

   if (eWhat == kDrillInfoDrillOn)
      this.drillCols[nCol] = true;
   else if (eWhat == kDrillInfoFilterOn)
      this.filterCols[nCol] = true;
}

function DrillInfo_DrillOn(nCol)
{
   this.drillCols[nCol] = true;
}

function DrillInfo_FilterOn(nCol)
{
   this.filterCols[nCol] = true;
}

function DrillInfo_SetPivotAllPages()
{
   this.pivotAllPages = true;
}

function DrillInfo()
{
   this.drillCols = new Array();
   this.filterCols = new Array();
   this.values = new Array();
   this.columns = new Array();
   this.pivotAllPages = false;
   
   this.EncodeDrillColumns = DrillInfo_EncodeDrillColumns;
   this.EncodeFilterColumns = DrillInfo_EncodeFilterColumns;
   this.EncodeQueryColumns = DrillInfo_EncodeQueryColumns;
   this.EncodeValues = DrillInfo_EncodeValues;
   this.EncodePivotStartingPage = DrillInfo_EncodePivotStartingPage;
   
   this.DrillOn = DrillInfo_DrillOn;
   this.FilterOn = DrillInfo_FilterOn;
   this.AddColumn = DrillInfo_AddColumn;
   this.AddValue = DrillInfo_AddValue;
   this.PivotAllPagesOn = DrillInfo_SetPivotAllPages;
   return this;
}

// for debugging
function DisplayDrillDownInfo(tDrillInfo)
{
   var sMsg = "Drill on columns = " + tDrillInfo.EncodeDrillColumns() + "\n\n";
   sMsg += "Filter columns = " + tDrillInfo.EncodeFilterColumns() + "\n\n";
   sMsg += "Query Columns = " + tDrillInfo.EncodeQueryColumns() + "\n\n";
   sMsg += "Values = " + tDrillInfo.EncodeValues();
   alert(sMsg);
}

// //////////////////////////////////////////////////////////////////////////
// When Inline, SWE adds the following to our Drill Form

//SWECmd=InvokeMethod
//SWEMethod=ProxyUrl
//Parameters with dynamically generated values:
//SWECount
//SWEView
//SWEApplet
//SFixup
//URL=our original form action



function FormInputToURL(tForm,sName)
{
   var sURL = "";

   var tInput = tForm.elements[sName];
   if ((tInput != null) && (tInput.value != ""))
      sURL = "&" + sName + "=" + saw.encodeURIComponent(tInput.value);

   return sURL
}


function DrillFormToURL(tForm, sAction)
{
   var sURL = tForm.elements["URL"].value;
   sURL += "&Action=" + saw.encodeURIComponent(sAction);

   sURL += FormInputToURL(tForm, "ViewID");
   sURL += FormInputToURL(tForm, "ViewState");
   sURL += FormInputToURL(tForm, "Options");
   sURL += FormInputToURL(tForm, "Style");
   sURL += FormInputToURL(tForm, "ViewName");
   sURL += FormInputToURL(tForm, "PivotAllPages");
   sURL += FormInputToURL(tForm, "P0");
   sURL += FormInputToURL(tForm, "P1");
   sURL += FormInputToURL(tForm, "P2");
   sURL += FormInputToURL(tForm, "P3");

   return sURL;
}

function DrillDown(tForm, tDrillInfo)
{
   // set expected parameters
   if (!tForm || !tForm.P0 || !tForm.P1 || !tForm.P2 || !tForm.P3 || !tForm.Action)
      return;

   tForm.P0.value = tDrillInfo.EncodeDrillColumns();
   tForm.P1.value = tDrillInfo.EncodeQueryColumns();
   tForm.P2.value = tDrillInfo.EncodeValues();
   tForm.P3.value = tDrillInfo.EncodeFilterColumns();
   
   if (typeof(tForm.PivotAllPages) != "undefined" && tForm.PivotAllPages != null)
      tForm.PivotAllPages.value = tDrillInfo.EncodePivotStartingPage();
   
// alert(tForm.action + "\r\n" + tForm.innerHTML);

   if (typeof(tForm.SWECmd) != "undefined") // We're inline - it rewrote our form
   {
      // It turns out, because of the rewrites done by SWE, the only
      // change we need to make is to encode our form parameters into
      // the URL input of the form before submitting

//    alert(DrillFormToURL(tForm,"Drill"));
      saw.addHiddenInput(tForm,"URL",DrillFormToURL(tForm,"Drill"));

//    tForm.action = window.location.protocol + "//" + window.location.host + window.location.pathname;
   }

   // submit
// alert(tForm.action + "\r\n" + tForm.innerHTML);
   submitViewForm(tForm,null);
}

//-------------------
function DrillBack(sViewID, sViewState)
{
   var tForm = GetViewForm(sViewID);
   tForm.Action.value = "DrillBack";

   if (saw.dashboard)
      tForm.StateAction.value = sViewState;
   else
      tForm.ViewState.value = sViewState;
      
   submitViewForm(tForm,null);
   return false;
}

