
var g_tLastMousedownEvent = new Object;
var g_tMenuPrevPopup= null;
var g_bAllowMenuPopup=true;

saw.menuPrivs = function()	{}
saw.menu = function()	{}

saw.activeMenu	= null;

//	Public methods
saw.menuMousedown = function(event)
{
   g_tLastMousedownEvent.clientX = event.clientX;
   g_tLastMousedownEvent.clientY = event.clientY;

   g_bAllowMenuPopup = true;

   // If there is no active	button, exit.

   if (saw.activeMenu == null)
      return;

   // Find the element that	was clicked	on.
   var el = saw.getEventSrcElement(event);

   // If the active button was clicked on, exit.
   if (el == saw.activeMenu)
      return;

   // If the scrollbar of the window is clicked, exit
   if (saw.menuPrivs.isScrollBarClicked(el, event))
      return;

   if (NQWGetContainer(el, 'DIV', 'className', 'NQWMenu') == null)
   {
      saw.menuPrivs.resetMenu(saw.activeMenu);
      saw.activeMenu =	null;

      g_bAllowMenuPopup = false;

      return false;
   }
}

saw.clearActiveMenu = function()
{
	if(saw.activeMenu	!=	null)
	{
		saw.menuPrivs.resetMenu(saw.activeMenu);

		saw.activeMenu	= null;
	}
}

//	tDir can	be	left for	a drop down	list simulation
saw.popupMenu = function(evt, menuId, fInitializeMenu,	tDir)
{
   return saw.popupMenuByRefObj(evt, null, menuId, fInitializeMenu, tDir);
}

// added this function is handle the situation that we don't have the evt object
saw.popupMenuByRefObj = function(evt, tClicked, menuId, fInitializeMenu, tDir)
{
   var clicked = tClicked;
   if (!clicked && evt)
     clicked = saw.getEventTarget(evt);

   if (!menuId)
      menuId = clicked.getAttribute("menuId");

   if(g_bAllowMenuPopup ==	false && g_tMenuPrevPopup == clicked)
      return false;

   g_tMenuPrevPopup = clicked;

   var tMenu =	document.getElementById(menuId);
   if(tMenu == null)
   {
      alert("Menu	'"	+ menuId	+ "' not	found	in	document!");
      return false;
   }

   if (saw.activeMenu != null)
      saw.menuPrivs.resetMenu(saw.activeMenu);

   if (!saw.menuPrivs.init(evt, tMenu, fInitializeMenu, clicked))
      return false;

   if(tMenu != saw.activeMenu)
   {
      NQWPositionPopup(clicked, tMenu,	tDir);
      saw.menuPrivs.show(tMenu);
      
      saw.menuPrivs.populateMenuItems(tMenu);
      saw.menuPrivs.focusMenuItem(tMenu, 0);
      window.setTimeout('saw.addEventListener(document, "keydown", saw.menuPrivs.keyDownEventHandler)', 500);
      window.setTimeout('saw.addEventListener(document, "keyup", saw.menuPrivs.keyboardEventHandler)', 500);
   }
   return false;
}

// popup menu at position (x, y)
saw.menu.popupAt = function(tMenu, x, y)
{
   if(tMenu == null)
      return false;

	if	(saw.activeMenu != null)
		saw.menuPrivs.resetMenu(saw.activeMenu);

   if (!saw.menuPrivs.init(null, tMenu, null, null))
      return false;

   if(tMenu != saw.activeMenu)
   {
      tMenu.style.position = 'absolute';
      tMenu.style.left = x + saw.getDocumentScrollLeft() + 'px';
      tMenu.style.top = y + saw.getDocumentScrollTop() + 'px';

      saw.menuPrivs.show(tMenu);
   }
   return false;
}

saw.menuMouseOut = function(event)
{
  var	tMenu;

  if (is_ie)
	 tMenu =	NQWGetContainer(saw.getEventTarget(event), 'DIV', 'className',	'NQWMenu');
  else
	 tMenu =	event.currentTarget;

	if(typeof(tMenu.nTimeout) != 'undefined' && tMenu.nTimeout != null)
	{
		window.clearTimeout(tMenu.nTimeout);
		tMenu.nTimeout	= null;
	}
}

saw.menuMouseOver	= function(event)
{
   var	tMenu;

   if (is_ie)
	   tMenu =	NQWGetContainer(saw.getEventTarget(event), 'DIV', 'className',	'NQWMenu');
   else
	   tMenu =	event.currentTarget;

   if(tMenu.activeItem)
      NQWSetHasClassName(tMenu.activeItem, 'NQWMenuItemHighlight', false);
         
	if(tMenu.subMenuItem	==	null)
		saw.menuPrivs.doMenuMouseOver(tMenu);
	else
	{
		if(typeof(tMenu.nTimeout) != 'undefined' && tMenu.nTimeout != null)
			window.clearTimeout(tMenu.nTimeout);

		tMenu.nTimeout	= window.setTimeout('saw.menuPrivs.timedDoMenuMouseOver("' + tMenu.id +	'")',	200);
	}
}

saw.menuItemMouseOver =	function(event, menuId,	optMenuArg)
{
   if(event)
   {
     var	item,	tMenu, x, y;

	  item = NQWGetContainer(saw.getEventTarget(event),	'A', 'className',	'NQWMenuItem');
     if (!item)
	     item = NQWGetContainer(saw.getEventTarget(event),	'A', 'className',	'NQWLeftMenuItem');

     tMenu = NQWGetContainer(item, 'DIV',	'className', 'NQWMenu');

     // Close any	active sub tMenu and	mark this one as active.

      if (tMenu.subMenuItem	!=	null)
      {
	      if(tMenu.subMenuItem	==	item)
	      {
		      if(typeof(tMenu.nTimeout) != 'undefined' && tMenu.nTimeout != null)
		      {
			      window.clearTimeout(tMenu.nTimeout);
			      tMenu.nTimeout	= null;
		      }
		      if	(is_ie)
			      event.cancelBubble = true;
	      else
			      event.stopPropagation();

		      return;
	      }

	      if(typeof(tMenu.nTimeout) != 'undefined' && tMenu.nTimeout != null)
	      {
		      window.clearTimeout(tMenu.nTimeout);

	      }

	      tMenu.eventItem =	item;

	      tMenu.nTimeout	= window.setTimeout('saw.menuPrivs.timedDoMenuItemMouseOver("'	+
		      tMenu.id	+ '","'+menuId+'","'+optMenuArg+'")',200);
   //		saw.menuPrivs.closeSubMenu(tMenu);
      }
      else
	      saw.menuPrivs.doMenuItemMouseOver(tMenu, item, menuId, optMenuArg);

    if (is_ie)
	    event.cancelBubble = true;
     else
	    event.stopPropagation();
   }
}

saw.menuCheckmarkItems = function(tMenu, sAttr,	sValue)
{
	 var tList = tMenu.getElementsByTagName('A')

	for(var i =	0 ; i	!=	tList.length ;	++i)
	{
		var sMIAV =	tList[i].getAttribute(sAttr);

		if(sMIAV	!=	null)
			NQWSetHasClassName(tList[i], 'NQWMenuItemChecked',	sValue == sMIAV);
	}
}

//get the parent object of menu items
// need when changing the menu item in javascript
saw.getMenuItemContainer = function(tMenu)
{
   if (saw.menuPrivs.hasDropShadow(tMenu))
      return saw.getFirstChildElement(tMenu).rows[0].cells[0];
   else
      return tMenu;
}


//call this function after changing the menu item after menu is displayed
//Typical use case: display a menu saying "please wait", use AJAX to retrieve the menu item and update the menu
saw.menu.reposition = function(tMenu, tRefObj)
{
   saw.menuPrivs.adjustShadowSize(tMenu);
   //change the position of the menu if necessary
   var sDir = tMenu.getAttribute("sDir") ? tMenu.getAttribute("sDir") : 'right';
   if (sDir == 'left')
      NQWPositionPopup(tRefObj, tMenu, sDir);
}

///////////////////////////////////////////////////////////////////////////////
//	Private methods

saw.menuPrivs.init = function(evt, tMenu, fInitializeMenu, clicked)
{
   if(tMenu.getAttribute("bInit") == null)
   {
      saw.menuPrivs.menuInit(tMenu);
   }

   if(fInitializeMenu != null)
   {
      fInitializeMenu(evt, clicked.tMenu);
   }
   else if(tMenu.getAttribute("menuInit"))
   {
      //	SAL: 11/24/2004 -	checked out	eval.	necessary because	the value of this
      //	attribute could be something like a.b.c and in that case	eval is probably faster.
      var fFunc = eval(tMenu.getAttribute("menuInit"));

      //	allow	init function to prevt tMenu from	appearing
      if (fFunc(evt, tMenu) == false)
         return false;
   }
   
   return true;
}

saw.menuPrivs.show = function(tMenu)
{
   saw.hideSelects(tMenu);
   if (is_nav)
      saw.hideCharts(tMenu);

   saw.menuPrivs.adjustShadowSize(tMenu);
   tMenu.style.visibility = 'visible';
   saw.activeMenu	= tMenu;

   saw.preventMainBarJump();   
}

saw.menuPrivs.resetMenu	= function(tMenu)	{

   if (tMenu	!=	null)	{
	   saw.showSelects(tMenu);
      if (is_nav)
 		   saw.showCharts(tMenu);
	   saw.menuPrivs.closeSubMenu(tMenu);
	   saw.removeEventListener(document, "keydown", saw.menuPrivs.keyDownEventHandler);
	   saw.removeEventListener(document, "keyup", saw.menuPrivs.keyboardEventHandler);
	   tMenu.style.visibility	= 'hidden';
	   
	   saw.preventMainBarJump();
   }
}

saw.menuPrivs.doMenuMouseOver	= function(tMenu)
{
  if (tMenu.subMenuItem	!=	null)
	 saw.menuPrivs.closeSubMenu(tMenu);
}

saw.menuPrivs.timedDoMenuMouseOver = function(menuId)
{
	var tMenu =	document.getElementById(menuId);

	if(tMenu	!=	null)
	{
		tMenu.nTimeout	= null;

		saw.menuPrivs.doMenuMouseOver(tMenu);
	}
}

saw.menuPrivs.timedDoMenuItemMouseOver	= function(menuId, subMenuId,	optMenuArg)
{
	var tMenu =	document.getElementById(menuId);

	if(tMenu	!=	null)
	{
		tMenu.nTimeout	= null;
		saw.menuPrivs.doMenuItemMouseOver(tMenu, tMenu.eventItem, subMenuId,	optMenuArg);
	}
}

saw.menuPrivs.doMenuItemMouseOver =	function(tMenu,item,	menuId, optMenuArg)
{
	if(tMenu.subMenuItem	!=	null)
		saw.menuPrivs.closeSubMenu(tMenu);

  tMenu.subMenuItem = item;

  NQWAddClassName(item,'NQWMenuItemHighlight');
  if (item.subMenu == null) {
	 item.subMenu = document.getElementById(menuId);
	 if (item.subMenu.bInit	==	null)
		saw.menuPrivs.menuInit(item.subMenu);
  }

  if(item.subMenu.getAttribute("subMenuInit"))
  {
		if(item.subMenu.fSubMenuInit == null)
		{
			item.subMenu.fSubMenuInit = eval(item.subMenu.getAttribute("subMenuInit"));//window[item.subMenu.getAttribute("subMenuInit")];
		}

		item.subMenu.fSubMenuInit(tMenu,	item.subMenu, optMenuArg);
  }
  
  item.subMenu.parentItem = item;


   NQWPositionPopup(item, item.subMenu, item.subMenu.getAttribute("sDir") ? item.subMenu.getAttribute("sDir") : 'right');

   saw.hideSelects(item.subMenu);
   if (is_nav)
 		   saw.hideCharts(item.subMenu);
    
   saw.menuPrivs.adjustShadowSize(item.subMenu);
   
   //move 6px right(width of drop shadow) to make the border of the submenu touch its parent
   if (saw.menuPrivs.hasDropShadow(item.subMenu) && item.subMenu.getAttribute("sDir") == 'left')
   {
      if (!saw.isRToL())
      {
         var nLeftPos = parseInt(item.subMenu.style.left);
         if (nLeftPos)
            item.subMenu.style.left = nLeftPos + saw.menuPrivs.getShadowWidth(item.subMenu) + "px";
      }
      else
      {
         var nRightPos = parseInt(item.subMenu.style.right);
         if (nRightPos)
            item.subMenu.style.right = nRightPos + saw.menuPrivs.getShadowWidth(item.subMenu) + "px";
      }
   }
   
   item.subMenu.style.visibility = 'visible';
   saw.menuPrivs.populateMenuItems(item.subMenu);
   saw.menuPrivs.focusMenuItem(item.subMenu, 0);
   saw.preventMainBarJump();

 }

saw.menuPrivs.closeSubMenu	= function(tMenu)
{

   if (tMenu	==	null || tMenu.subMenuItem == null)
	   return;

   if(typeof(tMenu.nTimeout) != 'undefined' && tMenu.nTimeout != null)
   {
	   window.clearTimeout(tMenu.nTimeout);
	   tMenu.nTimeout	= null;
   }

   if (tMenu.subMenuItem.subMenu != null) {
      saw.showSelects(tMenu.subMenuItem.subMenu);
      if (is_nav)
   	   saw.showCharts(tMenu.subMenuItem.subMenu);
	   saw.menuPrivs.closeSubMenu(tMenu.subMenuItem.subMenu);
	   tMenu.subMenuItem.subMenu.style.visibility = 'hidden';
	   tMenu.subMenuItem.subMenu	= null;
	   
	   saw.preventMainBarJump();
   }

   NQWRemoveClassName(tMenu.subMenuItem, 'NQWMenuItemHighlight');
   tMenu.subMenuItem = null;
}

saw.menuPrivs.menuInit = function(tMenu)
{
   saw.menu.resetShadow(tMenu);

  var	itemList, spanList
  var	textEl, arrowEl;
  var	itemWidth;
  var	w,	dw;
  var	i,	j;

  if (is_ie) {
  //	tMenu.style.lineHeight = '2.5ex';
  }

  itemList = tMenu.getElementsByTagName('A');
  if (itemList.length >	0)
		itemWidth =	itemList[0].offsetWidth;
  else
	 return;

  for	(i	= 0; i <	itemList.length; i++)
  {
		spanList	=	itemList[i].getElementsByTagName('SPAN')
		textEl	= null
		arrowEl	= null;
		for (j =	0;	j	< spanList.length; j++)	{
			if	(NQWHasClassName(spanList[j],	'NQWMenuItemText'))
			textEl	= spanList[j];
			if	(NQWHasClassName(spanList[j],	'NQWMenuItemArrow'))
			arrowEl =	spanList[j];
		}
		if	(textEl	!=	null && arrowEl != null)
			textEl.style.paddingRight = (itemWidth
			- (textEl.offsetWidth	+ arrowEl.offsetWidth))	+ 'px';
  }

  //if (is_ie)
  {
		w	= itemList[0].offsetWidth;
		itemList[0].style.width	=	w + 'px';
		dw	=	itemList[0].offsetWidth	- w;
		w	-=	dw;
		itemList[0].style.width	=	w + 'px';
  }

  tMenu.setAttribute("bInit",	true);
}

//-----------------------------------------------------------------------------
// menu dropshadow

//get the width of the drop shadow
saw.menuPrivs.getShadowWidth = function(tMenu)
{
   if (saw.menuPrivs.hasDropShadow(tMenu))
      return saw.getFirstChildElement(tMenu).rows[2].cells[2].clientWidth;
   else
      return 0;
}

// return true if a menu has dropshadow
saw.menuPrivs.hasDropShadow = function(tMenu)
{
   var tShadowTable = saw.getFirstChildElement(tMenu);
   if (tShadowTable)
      return tShadowTable.className == 'menuShadowWrapper' || tShadowTable.tagName == 'TABLE';
   
   return false;
}

// called just before the popup menu became visible
saw.menuPrivs.adjustShadowSize = function(tMenu)
{
   if (saw.menuPrivs.hasDropShadow(tMenu))
   {
      // ie doesn't generate cell with correct size:( 
      // used to walkaround it
            
      if (is_ie || is_mac)
      {
         saw.menu.resetShadow(tMenu);
         
         var tShadowTable = saw.getFirstChildElement(tMenu);

         //saw.fixDropShowdowStyle(tShadowTable);
            
         var height = tMenu.clientHeight - tShadowTable.rows[2].cells[2].clientHeight * 2;
         tShadowTable.rows[1].cells[0].style.height = height + "px";
         var width = tMenu.clientWidth - tShadowTable.rows[2].cells[2].clientWidth * 2;
         tShadowTable.rows[2].cells[1].style.width = width + "px";
      }
   }
   else
   {
      // set the style in case there is no shadow
   	  tMenu.style.border = "#a5a9b6 1px solid";
      if (is_ie)
         tMenu.style.filter = "alpha(opacity=95)";
      else
         tMenu.style.opacity = "0.95";   
      tMenu.style.padding ="0px 1px 1px 1px";
      tMenu.style.backgroundColor = "#f2f2f5";
   }
}

// reset the menu drop-shadow, remove the shadow size set when rendering the menu last time
// this function may be called after menu items are changed
saw.menu.resetShadow = function(tMenu)
{
   if (is_ie && saw.menuPrivs.hasDropShadow(tMenu))
   {
      var tShadowTable = saw.getFirstChildElement(tMenu);
      tShadowTable.rows[1].cells[0].style.height = "auto";
      tShadowTable.rows[2].cells[1].style.width = "auto";
   }
}

saw.menuPrivs.isScrollBarClicked = function(el, evt)
{
   if (el.tagName != 'HTML')
      return false;

   //in case of RTL language, ie have the vertical scroll bar on the left side of the window
   var isVScrollBarOnTheRight = !saw.isRToL() || (saw.isRToL() && !is_ie); 
   
   var x = saw.getEventPageX(evt) - saw.getDocumentScrollLeft();
   if (isVScrollBarOnTheRight && x < saw.getClientWidth()
         || !isVScrollBarOnTheRight && x > 20)
   {
      if (!saw.hasHScrollBar())
         return false;
         
      var y = saw.getEventPageY(evt) - saw.getDocumentScrollTop();
      if (y < saw.getClientHeight() - 20) //saw.getClientHeight() include scrollbar
         return false;
   }
   
   return true;
}

saw.menuPrivs.keyDownEventHandler = function(event)
{
   saw.stopEvent(event);
}

saw.menuPrivs.keyboardEventHandler = function(event)
{
   var keyCode = event.keyCode;
   switch(keyCode)
   {
      case 9: // tab
         saw.menuPrivs.closeMenu();
         break;
      case 13: // enter
      case 39: // right
		   saw.menuPrivs.handleEnter(event);
         break;
      case 27: // escape
      case 37: // left
         saw.menuPrivs.closeLastSubMenu();
         break;
      case 38: // up
         saw.menuPrivs.cycleItem(false);
		   break;
		case 40: // down
         saw.menuPrivs.cycleItem(true);
		   break;
   }
   saw.stopEvent(event);
}

saw.menuPrivs.handleEnter = function(evt)
{
   var target = saw.getEventTarget(evt);
   var onmouseover = target.onmouseover;
   if(onmouseover)
   {
      var str = onmouseover.toString();
      if(str.indexOf("saw.menuItemMouseOver") >= 0 || str.indexOf("saw.menu.onItemMouseOver") >= 0)
         target.onmouseover(evt);
   }
   else if(target.onclick)
      target.onclick(evt);
}

saw.menuPrivs.closeMenu = function()
{
   saw.menuPrivs.resetMenu(saw.activeMenu);
   saw.activeMenu = null;
   g_tMenuPrevPopup.focus();
   saw.menu.bAllowMenuPopup = true;
}

saw.menuPrivs.closeLastSubMenu = function()
{
   var lastSubMenu = saw.menuPrivs.getLastSubMenu();
   if(lastSubMenu && lastSubMenu.parentItem)
   {
      var parentMenu = NQWGetContainer(lastSubMenu.parentItem, 'DIV', 'className', 'NQWMenu');
      saw.menuPrivs.closeSubMenu(parentMenu);
      parentMenu.activeItem.focus();
      NQWSetHasClassName(parentMenu.activeItem, 'NQWMenuItemHighlight', true);
   }
   else
      saw.menuPrivs.closeMenu();
}

saw.menuPrivs.getLastSubMenu = function()
{
   var menu = saw.activeMenu;
   while(menu)
   {
      if(menu.subMenuItem && menu.subMenuItem.subMenu)
         menu = menu.subMenuItem.subMenu;
      else
         break;
   }
   return menu;
}

saw.menuPrivs.cycleItem = function(bDown)
{
   var menu = saw.menuPrivs.getLastSubMenu();
   if(!menu || menu.menuItems.length == 0)
      return;
   
   var menuItems = menu.menuItems;
   var size = menuItems.length;
   for(var i = 0; i < size; ++i)
   {
      if(menuItems[i] == menu.activeItem)
      {
         if(bDown)
         {
            if(i == size-1)
               index = 0;
            else
               index = ++i;
         }
         else
         {
            if(i == 0)
               index = size - 1;
            else
               index = --i;
         }
         saw.menuPrivs.focusMenuItem(menu, index);
         break;
      }
   }
}

saw.menuPrivs.populateMenuItems = function(tMenu)
{
   tMenu.menuItems = new Array();
   var alist = tMenu.getElementsByTagName('a');
   for(var i = 0; i < alist.length; ++i)      
   {
      if(alist[i].style.display != "none")
         tMenu.menuItems.push(alist[i]);
   }
}

saw.menuPrivs.focusMenuItem = function(tMenu, index)
{
   if(tMenu.menuItems && tMenu.menuItems.length > index)
   {
      if(tMenu.activeItem)
         NQWSetHasClassName(tMenu.activeItem, 'NQWMenuItemHighlight', false);
         
      tMenu.menuItems[index].focus();
      tMenu.activeItem = tMenu.menuItems[index];
      NQWSetHasClassName(tMenu.activeItem, 'NQWMenuItemHighlight', true);
   }
}



saw.addEventListener(document, 'mousedown', saw.menuMousedown);

//	DEPRECATED
NQWPopupMenu =	saw.popupMenu;
NQWClearActiveMenu =	saw.clearActiveMenu;
NQWMenuMousedown = saw.menuMousedown;
NQWMenuMouseOver = saw.menuMouseOver;
NQWMenuMouseOut =	saw.menuMouseOut;
MQWMenuItemMouseOver	= saw.menuItemMouseOver;
NQWCheckmarkMenuItems =	saw.menuCheckmarkItems;
