///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// UIBtnBar - Info object and event handler
///////////////////////////////////////////////////////////////////////////////

// enums from C++
var kSeparator = 0;
var kActive = 1;
var kInactive = 2;
var kDisabled = 3;

// enums from C++
var kSingleSelect = 0;
var kMultipleSelect = 1;
var kCustomSelect = 2;

// records state of button
function NQBtnBarBtn(sName_, bAutoUnique_, sImg_, eStatus_)
{
	this.sName = sName_;
	this.bAutoUnique = (bAutoUnique_ == null ? false : bAutoUnique_);
	this.sImg = sImg_;
	this.eStatus = eStatus_;

	return this;
}

function NQBtnBar_PushButton(sName,bAutoUnique,sImg,eStatus)
{
	this.vButtons[this.vButtons.length] = new NQBtnBarBtn(sName,bAutoUnique,sImg,eStatus);
}

function NQBtnBar_EncodeState(bEncodeSeparators)
{
	var kSep = '~';

	var aBtns = this.vButtons;

	var sEncoded = "";

	var nEncoded = 0;

	for (var i = 0; i != aBtns.length; ++i)
	{
		var tBtn = aBtns[i];

		if (tBtn != null)
		{
			if (!bEncodeSeparators && tBtn.eStatus == kSeparator)
				continue;

			if (nEncoded > 0)
				sEncoded += kSep;

			++nEncoded;

			sEncoded += tBtn.sName + kSep + tBtn.bAutoUnique + kSep + tBtn.eStatus;
		}
	}

	if (nEncoded > 0)
		sEncoded = nEncoded + kSep + sEncoded;

	return sEncoded;
}

function NQBtnBar_GetButton(nBtn)
{
	return this.vButtons[nBtn];
}

function NQBtnBar_NumButtons()
{
	return this.vButtons.length;
}

function NQBtnBar()
{
	this.vButtons = new Array();
	this.EncodeState = NQBtnBar_EncodeState;
	this.GetButton = NQBtnBar_GetButton;
	this.PushButton = NQBtnBar_PushButton;
	this.NumButtons = NQBtnBar_NumButtons;
	this.sUserParam = ""; // should not be null
	return this;
}

function NQBtnBarArrayEncode(aButtonBars,bEncodeSeparators)
{
	var kSep = '~';

	var sEncoded = "";

	var bStarted = false;

	for (var i = 0; i != aButtonBars.length; ++i)
	{
		var tBB = aButtonBars[i];

		if (tBB != null)
		{
			if (bStarted)
				sEncoded += kSep;
			else
				bStarted = true;

			sEncoded += tBB.sUserParam + kSep + tBB.EncodeState(bEncodeSeparators);
		}
	}

	return sEncoded;
}

// handles onclick event
function onBtnBarClick()
{
	var tMe = onBtnBarClick;

	// name of variable
	var tBtnBar = tMe.arguments[0];

	// image related args
	var nBtn = tMe.arguments[1];

	// custom on-click handler
	var tOnClickFcn = tMe.arguments[2];

	// num args for custom handler
	var nMyArgs = 3;
	var nNumArgs = tMe.arguments.length - nMyArgs;

	var bProcess = true;

	if (tOnClickFcn != null)
	{
		switch (nNumArgs)
		{
		case 0:
			bProcess = tOnClickFcn(tBtnBar,nBtn);
			break;
		case 1:
			bProcess = tOnClickFcn(tBtnBar,nBtn,tMe.arguments[nMyArgs]);
			break;

		case 2:
			bProcess = tOnClickFcn(tBtnBar,nBtn,tMe.arguments[nMyArgs],tMe.arguments[nMyArgs+1]);
			break;

		case 3:
			bProcess = tOnClickFcn(tBtnBar,nBtn,tMe.arguments[nMyArgs],tMe.arguments[nMyArgs+1],
				tMe.arguments[nMyArgs+2]);
			break;

		case 4:
			bProcess = tOnClickFcn(tBtnBar,nBtn,tMe.arguments[nMyArgs],tMe.arguments[nMyArgs+1],
				tMe.arguments[nMyArgs+2],tMe.arguments[nMyArgs+3]);
			break;
		}
	}

	if ((bProcess == true) && (tBtnBar.eType != kCustomSelect))
	{
		// process this button
		var tBtn = tBtnBar.GetButton(nBtn);

		// sanity check
		if (!tBtn) { return; }

		if (tBtn.eStatus == kActive)
		{
			document.images[tBtn.sName].src = WebScriptMapGet(tBtn.sImg + "_off.gif");
			tBtn.eStatus = kInactive;
		}
		else if (tBtn.eStatus == kInactive)
		{
			document.images[tBtn.sName].src = WebScriptMapGet(tBtn.sImg + ".gif");
			tBtn.eStatus = kActive;
		}

		if (tBtnBar.eType == kSingleSelect)
		{
			for (var i = 0; i < tBtnBar.NumButtons(); ++i)
			{
				var tBtn = tBtnBar.GetButton(i);
				if ((tBtn.eStatus == kActive) && (i != nBtn))
				{
					document.images[tBtn.sName].src = WebScriptMapGet(tBtn.sImg + "_off.gif");
					tBtn.eStatus = kInactive;
				}
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
// HTMLExpander - Info object and event handler
///////////////////////////////////////////////////////////////////////////////

function ExpandCollapse(sID, event)
{
	// toggle cell of next object of class _ExpandThis
	//var j ;
   //for (j=0; j < saw.getEventTarget(event).all.length && saw.getEventTarget(event).all(j).className !="_ExpandThis"; j++);

   //make sure element is not off page (test for last link)
   var targetElement = document.getElementById(sID);
   //if ( (j<document.all.length) && (document.all(j).className == "_ExpandThis"))
	{
        //targetElement = document.all(j);
      if (targetElement.style.display == "none")
		{
            targetElement.style.display = "";

			var n = targetElement.offsetTop - saw.getEventTarget(event).offsetHeight;
			var h = targetElement.offsetHeight + saw.getEventTarget(event).offsetHeight;

			while(targetElement.offsetParent != null)
			{
				targetElement = targetElement.offsetParent;
				n += targetElement.offsetTop;
			}
			if(h < document.body.clientHeight)
			{

				if(n + h >
					document.body.scrollTop + document.body.clientHeight)
				{
					document.body.scrollTop = n + h - document.body.clientHeight;
				}
			} else document.body.scrollTop = n;
		}
        else {
            targetElement.style.display = "none";
        }
    }

    saw.stopEventPropagation(event);
}

///////////////////////////////////////////////////////////////////////////////
// Image helpers
///////////////////////////////////////////////////////////////////////////////

function PreloadImages(allpics) {
	if (document.images) {
		pics = new Array();
		for (i=0; i < PreloadImages.arguments.length; i++) {
			pics[i] = new Image();
			pics[i].src = PreloadImages.arguments[i];
		}
	}
}

function ImgOn(name,path) {
	if (document.images) {
		document.images[name].src = path + '_over.gif';
	}
}

function ImgOff(name,path) {
	if (document.images) {
		document.images[name].src = path + '.gif';
	}
}

