
// Copyright (C) 1999-2005 Siebel Systems, inc.  All rights reserved.

// for navigation
saw.pivot = new Object();

// sawNav:1; sweNav:2; 
saw.pivot.kInteractionSAWNav = 1;
saw.pivot.kInteractionSWENav = 2;

function PTPageChanged(sViewID, sValue)
{
	var sViewIdToRefresh = saw.view.getRefreshStatePath(sViewID,"pivotTableView");

	var tForm = GetViewForm(sViewID,sViewIdToRefresh);

	//var list = saw.checkObjectReference(eventSrc) ? eventSrc : saw.getEventTarget(event);
	tForm.Action.value = 'PTJimmyPage';
	tForm.P2.value = sValue; //document.forms["PTPageForm" + sViewID].P2.value;//list.options[list.selectedIndex].value;
	submitViewForm(tForm,null);
}

function PTGetValue(tc)
{
   var sDVal = (null != tc.DVal) ? tc.DVal : tc.getAttribute("DVal");
	if(sDVal == null)
		return saw.getInnerText(tc);

	return sDVal;
}

function PTGetTable(scttbl)
{
	if(scttbl.myTable == null)
	{
		scttbl.myTable = document.getElementById(scttbl.sTableID);
	}

	return scttbl.myTable;
}

function PTGetFromArray(vArray, r, vCols)
{
	var nLayers = vCols.length;

	var nFRCs = vArray[0].length;

	var nMissing = nLayers;
	var vValues = new Array();

	var nRow = r;

	while(nMissing > 0 && nRow >= 0)
	{
		var tRow = vArray[nRow];

		var n = nFRCs - tRow.length;

		if(n < nMissing)
		{
			for(var c = 0 ; c < nMissing - n ; ++c)
			{
				vValues[n + c] = tRow[c];
			}

			nMissing = n;
		}

		--nRow;
	}

	return vValues;
}

function PTRGetValues(scttbl, r, vArray)
{
	if(vArray != null)
		return PTGetFromArray(vArray, r, scttbl.yLayers);

	var tTable = PTGetTable(scttbl);

	var nFirstRow = scttbl.xLayers.length;

	var nRow = nFirstRow + r;

	var nLayers = scttbl.yLayers.length;

	if(!tTable.tableMatrix)
		tTable.tableMatrix = new TableMatrix(tTable);

	var tCells = tTable.tableMatrix.getRowCells(nRow, nLayers);

	for(var o = 0 ; o != tCells.length ; ++o)
		tCells[o] = PTGetValue(tCells[o]);

	return tCells;
}

function PTCGetValues(scttbl, r, vArray)
{
	if(vArray != null)
		return PTGetFromArray(vArray, r, scttbl.xLayers);

	var tTable = PTGetTable(scttbl);

	var nLayers = scttbl.xLayers.length;

	var nTC = r + scttbl.yLayers.length;

	if(!tTable.tableMatrix)
		tTable.tableMatrix = new TableMatrix(tTable);

	var tCells = tTable.tableMatrix.getColumnCells(nTC, nLayers);

	for(var o = 0 ; o != tCells.length ; ++o)
		tCells[o] = PTGetValue(tCells[o]);

	return tCells;
}

function PTRDrl(scttbl,l,r)
{
	var vValues = PTRGetValues(scttbl,r,scttbl.vRows);

	PTDrill(scttbl,vValues,scttbl.yLayers,l);

	return false;
}

function PTCDrl(scttbl,l,r)
{
	var vValues = PTCGetValues(scttbl,r,scttbl.vColumns);

	PTDrill(scttbl,vValues,scttbl.xLayers,l);

	return false;
}

function PTDrill(scttbl,vValues,vColumns,nLayer)
{
	var tDrillInfo = new DrillInfo();

	for(var p = 0 ; p < scttbl.vPageValues.length ; ++p)
	{
		var tValue = scttbl.vPageValues[p];

		if(tValue[0] != null)
		{
		    if (tValue[0] == -1 && tValue[1] == -1)
		    {   //set special page starting page in pivot table's All page vs Current page
		        tDrillInfo.PivotAllPagesOn();
		    }
		    else
		    {
		        tDrillInfo.AddValue(tValue[0],tValue[1]);
		        tDrillInfo.FilterOn(tValue[0]);
		    }
		}
	}

	for(var s = 0 ; s < scttbl.vSectionValues.length ; ++s)
	{
		var tValue = scttbl.vSectionValues[s];

		if(tValue[0] != null)
		{
			tDrillInfo.AddValue(tValue[0],tValue[1]);

			tDrillInfo.FilterOn(tValue[0]);
		}
	}

	for(var n = 0 ; n < vValues.length ; ++n)
	{
		var nColumn = vColumns[n];

		if(nColumn != null)
		{

			tDrillInfo.AddValue(nColumn,vValues[n]);

			if(n < nLayer)
				tDrillInfo.FilterOn(nColumn);
			else if(n == nLayer)
				tDrillInfo.DrillOn(nColumn);
		}
	}


	//DisplayDrillDownInfo(tDrillInfo);

	DrillDown(GetDrillForm(scttbl.sViewID),tDrillInfo);
}

function PTRNav(scttbl,l,r,evt, bInPreview)
{
	var vValues = PTRGetValues(scttbl,r,scttbl.vRows);

	PTNavigate(scttbl, scttbl.yNavs[l], vValues, scttbl.yLayers, l, evt, bInPreview);

	return false;
}

function PTCNav(scttbl,l,r,evt, bInPreview)
{
	var vValues = PTCGetValues(scttbl,r,scttbl.vColumns);

	PTNavigate(scttbl, scttbl.xNavs[l], vValues, scttbl.xLayers, l, evt, bInPreview);

	return false;
}

function PTMNav(scttbl, row, r, tNavSetup, nType, evt, bInPreview)
{
   var tInNavInfo = new NavigateInfo();

   // add all the row values
   var vRValues = PTRGetValues(scttbl,row,scttbl.vRows);
   for(var n = 0 ; n < scttbl.yLayers.length ; ++n)
   {
      // might be dealing with totals, look for null layers
      if (null == scttbl.yLayers[n])
         continue;
	   // if a measure, do not add the value
	   if (null != scttbl.vColumnAggs &&
	       null != scttbl.vColumnAggs[scttbl.yLayers[n]] &&
	       scttbl.vColumnAggs[scttbl.yLayers[n]])
	      continue;
      tInNavInfo.AddValue('eq', scttbl.vFormulas[scttbl.yLayers[n]], vRValues[n]);
   }

   // add all the column values
   var vCValues = PTCGetValues(scttbl,r,scttbl.vColumns);
   for(var n = 0 ; n < scttbl.xLayers.length ; ++n)
   {
      // might be dealing with totals, look for null layers
      if (null == scttbl.xLayers[n])
         continue;
	   // if a measure, do not add the value
	   if (null != scttbl.vColumnAggs &&
	       null != scttbl.vColumnAggs[scttbl.xLayers[n]] &&
	       scttbl.vColumnAggs[scttbl.xLayers[n]])
	      continue;
      tInNavInfo.AddValue('eq', scttbl.vFormulas[scttbl.xLayers[n]], vCValues[n]);
   }

   // let PTNavigate add just the page + section values and navigate
   PTNavigate(scttbl, tNavSetup, (new Array()), (new Array()), -1, evt, tInNavInfo, bInPreview);

   return false;
}

function PTHNav(scttbl, tNavSetup, nType, evt, bInPreview)
{
   PTNavigate(scttbl, tNavSetup, (new Array()), (new Array()), -1, evt, bInPreview);

   return false;
}

function PTNavigate(scttbl, tNavSetup, vValues, vLayerRS, nLayer, evt, tInNavInfo, bInPreview)
{
	if(tNavSetup == null)
		return;

	// tNavSetup looks like: [NavSetupFunc, setup opts...]

	var tNavInfo = (null != tInNavInfo) ? tInNavInfo : new NavigateInfo();

	tNavInfo.SetSearchID(scttbl.sSearchID);
	tNavInfo.SetViewID(scttbl.sViewID);

	for(var p = 0 ; p < scttbl.vPageValues.length ; ++p)
	{
		var tValue = scttbl.vPageValues[p];

		if(tValue[0] != null)
		{
			tNavInfo.AddValue('eq', scttbl.vFormulas[tValue[0]], tValue[1]);
		}
	}

	for(var s = 0 ; s < scttbl.vSectionValues.length ; ++s)
	{
		var tValue = scttbl.vSectionValues[s];

		if(tValue[0] != null)
		{
			tNavInfo.AddValue('eq', scttbl.vFormulas[tValue[0]], tValue[1]);
		}
	}

   // for SWE Nav, find the column whose value is what we really want to pass to SWE
   if (tNavSetup.type == saw.pivot.kInteractionSWENav)
   {
      tNavSetup.targets[0](tNavSetup.targets, tNavInfo);
      if (null != tNavInfo.sSWEView && null != tNavInfo.sSWESrcFormula)
      {
	      for(var n = 0 ; n <= vLayerRS.length ; ++n)
	      {
	         if (scttbl.vFormulas[vLayerRS[n]] == tNavInfo.sSWESrcFormula)
	         {
		         tNavInfo.AddValue('eq', scttbl.vFormulas[vLayerRS[n]], vValues[n]);
		         break;
		      }
	      }
      }
   }
   else if (tNavSetup.type == saw.pivot.kInteractionSAWNav)
   {
	   for(var n = 0 ; n <= nLayer ; ++n)
	   {
	      // if a measure, do not add the value
	      if (null != scttbl.vColumnAggs &&
	          null != scttbl.vColumnAggs[vLayerRS[n]] &&
	          scttbl.vColumnAggs[vLayerRS[n]])
	         continue;
		   tNavInfo.AddValue('eq', scttbl.vFormulas[vLayerRS[n]], vValues[n]);
	   }
	   tNavInfo.SetTargets(tNavSetup.targets[0]);
	}
	else
	{
	   return;
	}

   scttbl.oNavObject = tNavInfo;

   NQNavigate(evt, scttbl,bInPreview);
}
