//////////////////////////////////////////////////////////////////////////////
// Other view helpers
//

var strPortletIDReporPrefix="m:portlet~r:";


function getIdsMapElementId(viewID)
{
   var nIndex = viewID.indexOf(strPortletIDReporPrefix);
   if (nIndex != -1)
      viewID = viewID.substr(nIndex+strPortletIDReporPrefix.length,
                             viewID.length-nIndex-strPortletIDReporPrefix.length);
   nIndex = viewID.indexOf("~");
   if (nIndex != -1)
      viewID = viewID.substr(0,nIndex);
   return  viewID;
}


function getEffectiveID(sElemID,viewID)
{
   if (viewID == undefined || viewID == null ||  viewID.length ==0)
      return sElemID;

   var vDivID = getIdsMapElementId(viewID);
   vDiv  = document.getElementById(vDivID);
   if (vDiv == undefined ||  vDiv == null)
      return sElemID;

   var trueIDValue = vDiv.getAttribute("Effective_" + sElemID + "_ID");
   if (trueIDValue  != null)
      return trueIDValue;
   return sElemID;
}

function GetViewForm(sViewID)
{
	var tForm = document.forms[getEffectiveID("ViewForm",sViewID)];
	if (!tForm)
	   return null;

   if (tForm.ViewID)
   {
	   if(!sViewID)
		   tForm.ViewID.value = "";
	   else
		   tForm.ViewID.value = sViewID;
   }

   updateFormViewState(tForm);
	return tForm;
}

//This call is overwritten on dashboard.
function SubmitViewFormToRefresh(tForm)
{
	saw.submitForm(tForm,null);
}

function GetGoForm(sViewID,sTarget)
{
	var tForm = document.forms[getEffectiveID("GoForm",sViewID)];

   if (!tForm)
      return null;

	if (sTarget)
		tForm.target = sTarget;
	else
		tForm.target = "_self";

   if (tForm.ViewID)
	   tForm.ViewID.value = sViewID;

   //if in portal, then set up done url
   // this should really be setup properly when form is generated...
   if (tForm.Done && tForm.PortalPath && tForm.Done.value.indexOf("&PortalPath=") == -1 && tForm.PortalPath.value)
      tForm.Done.value += "&PortalPath=" + saw.encodeURIComponent(tForm.PortalPath.value);
   if (tForm.Done && tForm.Page && tForm.Done.value.indexOf("&Page=") == -1 && tForm.Page.value)
      tForm.Done.value += "&Page=" + saw.encodeURIComponent(tForm.Page.value);

	// this needs to be reset to ensure no view
	// has it set and we submit it and end up
	// going to some whacked out report.
	tForm.Path.value = "";

   updateFormViewState(tForm);

	return tForm;
}

function GetDrillForm(sViewID, bGetEmbed,bDontChangeDone)
{
	var tForm;

  
   var sParentViewID = sViewID.substr(0,sViewID.indexOf("~v:") == -1 ? sViewID.length : sViewID.indexOf("~v:"));
   if (saw.getReloadInline(sViewID, sParentViewID) || bGetEmbed)
   {
        tForm = GetViewForm(sViewID, sParentViewID);
         
        saw.addHiddenInput(tForm, "StateAction", "samepagestate");
        saw.addHiddenInput(tForm, "PivotAllPages", "");
        
        var aDrillForm = document.forms[getEffectiveID("DrillForm",sViewID)];
        if (aDrillForm)
        {
         
            //if in portal, then set up done url
            // this should really be setup properly when form is generated...
            var sDoneValue = "";
            if (aDrillForm.Done && aDrillForm.PortalPath && aDrillForm.Done.value.indexOf("&PortalPath=") == -1 && aDrillForm.PortalPath.value)
                sDoneValue = aDrillForm.Done.value + "&PortalPath=" + saw.encodeURIComponent(aDrillForm.PortalPath.value);
            if (aDrillForm.Done && aDrillForm.Page && aDrillForm.Done.value.indexOf("&Page=") == -1 && aDrillForm.Page.value)
                sDoneValue += "&Page=" + saw.encodeURIComponent(aDrillForm.Page.value);

            if (tForm.Done != undefined && !bDontChangeDone)
            {
                tForm.Done.value = sDoneValue;
                if (tForm.Options  != undefined)
                    tForm.Options.value += "s";
            }
                       
        }
   }
   else
   {
        tForm = document.forms[getEffectiveID("DrillForm",sViewID)];
        if (tForm.ViewID== undefined)
            tForm.innerHTML = tForm.innerHTML + "<input type=hidden name=ViewID value=" + sViewID + " >";
        else
            tForm.ViewID.value = sViewID;

        //if in portal, then set up done url
        // this should really be setup properly when form is generated...
        if(!bDontChangeDone)
        {
           if (tForm.Done && tForm.PortalPath && tForm.Done.value.indexOf("&PortalPath=") == -1 && tForm.PortalPath.value)
               tForm.Done.value += "&PortalPath=" + saw.encodeURIComponent(tForm.PortalPath.value);
           if (tForm.Done && tForm.Page && tForm.Done.value.indexOf("&Page=") == -1 && tForm.Page.value)
               tForm.Done.value += "&Page=" + saw.encodeURIComponent(tForm.Page.value);
        }
        if (tForm.Options)
            tForm.Options.value += "s";
   }

   tForm.Action.value = "drill";

   updateFormViewState(tForm,bDontChangeDone);

   return tForm
}

function updateFormViewState(tForm, bDontChangeDone)
{
   var tUpdatedViewStateDiv = document.getElementById("idViewStateDiv");
   if (tUpdatedViewStateDiv)
   {
      tForm.ViewState.value = tUpdatedViewStateDiv.getAttribute("stateID");
   }

   if(!bDontChangeDone)
   {
      if (tForm.Done && tForm.Done.value.indexOf("ViewState") < 0 && tForm.Done.value.indexOf("javascript:") < 0 &&
          tForm.ViewState && tForm.ViewState.value)
         tForm.Done.value += "&ViewState=" + tForm.ViewState.value;
      else if (tForm.Done && tUpdatedViewStateDiv)
      {
         var sTemp = tForm.Done.value.substr(tForm.Done.value.indexOf("ViewState"));
         var nNextAmp = sTemp.indexOf("&");
         if (nNextAmp < 0)
            nNextAmp = sTemp.length;
         var rExp = new RegExp(sTemp.substr(0, nNextAmp),"gi");
         tForm.Done.value = tForm.Done.value.replace(rExp, "ViewState=" + tUpdatedViewStateDiv.getAttribute("stateID"));
      }
   }

}

function submitViewForm(tForm, sNewAction)
{
   saw.submitForm(tForm, sNewAction);
}

function GoLink(sViewID,sAction)
{
	var tForm = GetGoForm(sViewID,"_blank");

	tForm.Action.value = sAction;

	if(sAction == 'Download')
	{
		var sURL = tForm.action;

		tForm.P19.value = ".csv";

		for(var i = 0 ; i != tForm.elements.length ; ++i)
		{
			if(tForm.elements[i].value != '')
				sURL += "&" + tForm.elements[i].name + "=" + saw.encodeURIComponent(tForm.elements[i].value);
		}

		window.location.href = sURL;
	} else
		saw.submitForm(tForm,null);
}

// This is written out for refresh link beneath results or when an error occurs.  We need to handle
// this in a variety of contexts as viewhelper.js is included on a number of pages in answers.
function HereLink(sViewID,sAction)
{
   // In Compound Layout View
   if (typeof(CompoundViewEditor) != "undefined")
   {
      CompoundViewEditor.refreshData();
   }

   // In Table View Editor
   else if (typeof(TableViewEditor) != "undefined")
   {
      TableViewEditor.onRefresh('idView');
   }

   // In Pivot View Editor
   else if (typeof(PivotViewEditor) != "undefined")
   {
      // Avoid js error for now (won't actually refresh past cache)
      XUIPreviewer.onClick('idPivotPreview');
   }
   
   else // Anywhere else (dashboard, preview, etc.)
   {
	   var tForm = GetViewForm(sViewID);

	   tForm.Action.value = sAction;
	   SubmitViewFormToRefresh(tForm);
	}
}

function GetMySearchID(tItem)
{
	// search for containing cell with nqvid
	while (tItem && !((tItem.tagName == "DIV" || tItem.tagName == "TD") && tItem.getAttribute("sid") != null))
		tItem = saw.getParentElement(tItem);

	if (tItem)
		return tItem.getAttribute("sid");
	else
		return "";
}

function GetMyViewID(tItem)
{
	// search for containing cell with nqvid
	while (tItem && !((tItem.tagName == "DIV" || tItem.tagName == "TD") && tItem.getAttribute("vid") != null))
		tItem = saw.getParentElement(tItem);

	if (tItem)
		return tItem.getAttribute("vid");
	else
		return "";
}

function PortalPageNav(event, sPortal,sPage)
{
	event = saw.getEvent(event);

	var tNavInfo = new NavigateInfo();

	tNavInfo.SetSearchID(GetMySearchID(saw.getEventTarget(event)));
	tNavInfo.SetViewID(GetMyViewID(saw.getEventTarget(event)));

	tNavInfo.SetTargets(new Array(new Array(NQWNavPortal,sPortal,sPage)));

	var nFilters = 0;

	for (var i = 3; (i+2 < arguments.length) && (nFilters < 10); i += 3)
	{
		var sTbl = arguments[i];
		var sCol = arguments[i+1];
		var sVal = arguments[i+2];

		if(sVal)
			tNavInfo.AddValue('eq',NQMakeFormula(sTbl,sCol),sVal);

		++nFilters;
	}

   tNavInfo.oNavObject = tNavInfo;
	NQNavigate(event, tNavInfo);
}

function PortalNav(event, sPortal,sTbl,sCol,sVal)
{
	PortalPageNav(event, sPortal,null,sTbl,sCol,sVal);
}

function NavigateInfo_SetPortal(sPortalPath, sPage, sIsMeasure)
{
	this.sPortal = sPortalPath;
	this.sPage = sPage;
	this.sIsMeasure = (null != sIsMeasure) ? sIsMeasure : "false";
}

function NavigateInfo_SetReportPath(sPath, sIsMeasure)
{
	this.sPath = sPath;
	this.sIsMeasure = (null != sIsMeasure) ? sIsMeasure : "false";
}

function NavigateInfo_SetActionLink(sSWEView, sSWEApplet, sSWESrcColumnID, sSWESrcFormula)
{
	this.sSWEView = sSWEView;
	this.sSWEApplet = sSWEApplet;
	this.sSWESrcColumnID = sSWESrcColumnID;
	this.sSWESrcFormula = sSWESrcFormula;
}

function NQFixTableName(sValue)
{
	if(sValue.search(/\s/) != -1)
		sValue = '"' + sValue + '"';

	return sValue;
}

function NavigateInfo_AddValue(sOp, sFormula, sValue)
{
	var tValue = new Object();

	tValue.sFormula = sFormula;
	
	if (sValue == null)
	   sValue = '*NQ_NULL*';

	if(sValue == '*NQ_NULL*')
	{
		tValue.sOp = (sOp == 'nin' || sOp == 'neq') ? 'nnull' : 'null';
	} else
	{
		tValue.sOp = sOp;
	}

	tValue.sValue = sValue;

	this.vValues[this.vValues.length] = tValue;
}

function NavigateInfo_SetSearchID(sSearchID)
{
	this.sSearchID = sSearchID;
}

function NavigateInfo_SetViewID(sViewID)
{
	this.sViewID = sViewID;
}

function NavigateInfo_SetTargets(vNavigationTargets)
{
	this.vTargets = vNavigationTargets;
}
function NavigateInfo_SetIsNewWindow(sWindowTarget) //sWindowTarget = '_blank' Target will be displayed in new window elase open in samewindow.
{
   this.sWindowTarget = sWindowTarget;
}
function NavigateInfo()
{
	this.SetReportPath = NavigateInfo_SetReportPath;
	this.SetPortal = NavigateInfo_SetPortal;
	this.SetActionLink = NavigateInfo_SetActionLink;
	this.AddValue = NavigateInfo_AddValue;
	this.SetSearchID = NavigateInfo_SetSearchID;
	this.SetViewID = NavigateInfo_SetViewID;
	this.SetTargets = NavigateInfo_SetTargets;
	this.SetIsNewWindow = NavigateInfo_SetIsNewWindow; 

	this.sPath = null;
	this.sPortal = null;
	this.sPage = null;
	this.sIsMeasure = null;
	this.sWindowTarget = "_self";

   this.sSWEView = null;
   this.sSWEApplet = null;
   this.sSWESrcColumnID = null;
   this.sSWESrcFormula = null;

	this.vValues = new Array();
	this.vTargets = null;
}

function NQNavigate(evt, tInfoBag,bInPreview)
{
   //prepare navigation target menu
   var tTargets = tInfoBag.oNavObject.vTargets;
   var tHandler = null;
   if (bInPreview)
      tHandler = "NQNavigateHandlerPreviewFrame("+tInfoBag.sJSObjName+",";
   else
      tHandler = "NQNavigateHandler("+tInfoBag.sJSObjName+",";
   var bSWE = tInfoBag.oNavObject.sSWEView != null;
   if(bSWE)
   {
      NQNavigateHandler(tInfoBag,null);
      return false;
   }

   if(tTargets.length == 1)
   {
      NQNavigateHandler(tInfoBag,0);
      return false;
   }
   
   if (bInPreview)
   {
       var tMenuDiv = parent.document.getElementById('idNavTargetMenu');

       var tMenuItems = parent.saw.getMenuItemContainer(tMenuDiv);    
        
       var tMenuDivMsg = "";
       var tMenuItemMsg = parent.document.getElementById('idNavTargetEntry').innerHTML;
        
       for(var i=0; i<tTargets.length; i++)
       {
          var tMsg = tMenuItemMsg.replace("_sawm_nav_menu_1", tHandler+i+")");
          tMsg = tMsg.replace("_sawm_nav_menu_2", tTargets[i][tTargets[i].length-1]);
          tMenuDivMsg = tMenuDivMsg + tMsg;
       }
        
       tMenuItems.innerHTML =  tMenuDivMsg;
        
       parent.saw.menu.resetShadow(tMenuDiv);
       if (evt != null)
           parent.NQWPopupMenu(evt, 'idNavTargetMenu', null, 'right');
       else
           parent.saw.menu.popupAt(tMenuDiv, parent.g_tLastMousedownEvent.clientX, parent.g_tLastMousedownEvent.clientY);
   }
   else
   {
       var tMenuDiv = document.getElementById('idNavTargetMenu');

       var tMenuItems = saw.getMenuItemContainer(tMenuDiv);    
        
       var tMenuDivMsg = "";
       var tMenuItemMsg = document.getElementById('idNavTargetEntry').innerHTML;
        
       for(var i=0; i<tTargets.length; i++)
       {
          var tMsg = tMenuItemMsg.replace("_sawm_nav_menu_1", tHandler+i+")");
          tMsg = tMsg.replace("_sawm_nav_menu_2", tTargets[i][tTargets[i].length-1]);
          tMenuDivMsg = tMenuDivMsg + tMsg;
       }
        
       tMenuItems.innerHTML =  tMenuDivMsg;
        
       saw.menu.resetShadow(tMenuDiv);
       if (evt != null)
           NQWPopupMenu(evt, 'idNavTargetMenu', null, 'right');
       else
           saw.menu.popupAt(tMenuDiv, g_tLastMousedownEvent.clientX, g_tLastMousedownEvent.clientY);
   }
   return false;
}

function NQNavigateHandlerPreviewFrame(tInfoBag, target)
{
    var tiframe = window.frames['idPivotPreviewIFrame'];
    if (tiframe != null)
        tiframe.NQNavigateHandler(tInfoBag, target);
}

//function NQNavigate(tForm, tNavInfo)
function NQNavigateHandler(tInfoBag, target)
{
   NQWClearActiveMenu();
   
   var tNavInfo = tInfoBag.oNavObject;
   var bSWE = tNavInfo.sSWEView != null;
   
	//Bug fix 9726733: Removed the limit on filters displayed (Independent of pxx params)
	var nVals = tNavInfo.vValues.length;

   if (bSWE)
   {
      if (nVals > 0)
	   {
	      var sNavValue = "";
	      for(var i = 0 ; i != nVals ; ++i)
	      {
	         var tValue = tNavInfo.vValues[i];
	         if (tValue.sFormula == tNavInfo.sSWESrcFormula)
	         {
	            sNavValue = tValue.sValue;
	            break;
	         }
	      }

	      if (sNavValue != "")
	      {
	         //alert ("Debug Message: Calling NQSWENav('" + tNavInfo.sSWEView + "', '" + tNavInfo.sSWEApplet +
	         //   "', '" + sNavValue + "');");
	         NQSWENav(tNavInfo.sSWEView, tNavInfo.sSWEApplet, sNavValue);
	      }
	   }
	   return;
	}

   var t = tNavInfo.vTargets[target];
   t[0](t, tNavInfo);
   var bPortal = tNavInfo.sPortal != null;
   var tForm = GetGoForm(tNavInfo.sViewID,tNavInfo.sWindowTarget);
   
//	alert(tNavInfo.sPortal);
//	alert(tNavInfo.sPage);
//	alert(tNavInfo.sPath);

   var tExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	if (nVals > 0)
   {
      // Create the filter expression
	   tExpr.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      tExpr.setAttribute("xsi:type", "sawx:logical");
      tExpr.setAttribute("op", "and");

	   for(var i = 0 ; i != nVals ; ++i)
	   {
		   var tValue = tNavInfo.vValues[i];

		   //tForm.elements['P' + (i*3 + 1)].value = tValue.sOp;
		   //tForm.elements['P' + (i*3 + 2)].value = tValue.sFormula;
		   //tForm.elements['P' + (i*3 + 3)].value = '1 ' + escapespaces(tValue.sValue);

		   var tFilterExpr = XUIAppendNewElement(tExpr, saw.xml.kSawxNamespace, 'expr');
         XUISetXsiType(tFilterExpr, saw.xml.kSawxNamespace, "comparison");
		   XUISetAttributeString(tFilterExpr, "op", (null != tValue.sOp && tValue.sOp == 'null') ? "null" : "equal");

         var tSQLExpr = XUIAppendNewElement(tFilterExpr, saw.xml.kSawxNamespace, 'expr');
         XUISetXsiType(tSQLExpr, saw.xml.kSawxNamespace, "sqlExpression");
         XUISetElementText(tSQLExpr, tValue.sFormula);

         if (null == tValue.sOp || tValue.sOp != 'null')
         {
            var tValueExpr = XUIAppendNewElement(tFilterExpr, saw.xml.kSawxNamespace, 'expr');
            XUISetXsiType(tValueExpr, saw.xml.kSawxNamespace, "untypedLiteral");
            XUISetElementText(tValueExpr, tValue.sValue);
         }
	   }

	   if (nVals == 1)
	      tExpr = tExpr.firstChild;
   }

   //adding updated viewstate
   var tUpdatedViewStateDiv = document.getElementById("idViewStateDiv");

	if(!(tForm == null || bPortal)) // must be a report with a go form
	{
		tForm.Action.value = 'Navigate';

		tForm.Path.value = tNavInfo.sPath;

	   if (nVals > 0)
		   tForm.P0.value = saw.getXmlText(tExpr);
		else
		   tForm.P0.value = "";
		tForm.P1.value = "page";
		tForm.P19.value = tNavInfo.sSearchID;
		var sReportStatePath = tNavInfo.sViewID.substr(0,tNavInfo.sViewID.indexOf("~v:") == -1 ? tNavInfo.sViewID.length : tNavInfo.sViewID.indexOf("~v:"));
      var tResultDiv = document.getElementById(sReportStatePath+"Result");
      if (tResultDiv)
         tForm.P18.value = tResultDiv.getAttribute("options").replace( new RegExp("s","gi"), "");

      // Check if in compound layout view or view edit preview iframe
		if ((typeof(CompoundViewEditor) != "undefined") || (typeof(TableViewEditor) != "undefined") || (typeof(PivotViewEditor) != "undefined") || (document.body.id == 'idViewPreview'))
		{
		   tForm.target = "_blank";
		   tForm.ViewState.value = "";
		}
		else if (NQWIsInAnswers()) // lets stay in answers preview
		{
		   tForm.action = GetViewForm().action;
		}

      if (tUpdatedViewStateDiv && tForm.ViewState)
         tForm.ViewState.value = tUpdatedViewStateDiv.getAttribute("stateID");

      // RIE: navigation needs
      // to clear the view id so it doesn't go back into the same view
      if (tForm.ViewID)
      {
         saw.addHiddenInput(tForm, "NavFromViewID", tForm.ViewID.value);
         tForm.ViewID.value = "";
      }
      //added for nav to report so we know where we came from and can save that state
      var sPageID = document.getElementById("idPageID");
      if (sPageID)
         saw.addHiddenInput(tForm, "PageID", sPageID.getAttribute("pageID"));

		NQWSubmitFormWithView(tForm,tNavInfo.sViewID,null);
	}
	else // portal or no go form passed
	{
		var sURL = null;

      tForm = document.forms["tempForm"];
      if (!tForm)
	      tForm = saw.createForm("tempForm");

	   if(bPortal)
	   {
	      tForm.action = saw.commandToURL("Dashboard");
   	   saw.addHiddenInput(tForm, "PortalPath", tNavInfo.sPortal);
   	   saw.addHiddenInput(tForm, "P1", "dashboard");
   	   if (tNavInfo.sPage)
            saw.addHiddenInput(tForm, "Page", tNavInfo.sPage);
	   }
	   else if(tForm == null)
	   {
	      tForm.action = saw.commandToURL("Go");
	      saw.addHiddenInput(tForm, "Path", tNavInfo.sPath);
	   }

	   saw.addHiddenInput(tForm, "Action", "Navigate");

      if (nVals > 0)
   	   saw.addHiddenInput(tForm, "P0", saw.getXmlText(tExpr));
   	else
   	   saw.addHiddenInput(tForm, "P0", "");
	   saw.addHiddenInput(tForm, "P19", tNavInfo.sSearchID);


      if (tUpdatedViewStateDiv)
      {
         saw.addHiddenInput(tForm, "StateAction", "NewPage");
         saw.addHiddenInput(tForm, "ViewState", tUpdatedViewStateDiv.getAttribute("stateID"));
      }

      // Check if in compound layout view or view edit preview iframe and open a new window
		if ((typeof(CompoundViewEditor) != "undefined") || (typeof(TableViewEditor) != "undefined") || (typeof(PivotViewEditor) != "undefined") || (document.body.id == 'idViewPreview'))
		{
		   tForm.target = "_blank";
		}
		else if (NQWIsInAnswers()) // replace parent - jump to portal
		{
			tForm.target = "_parent";
		}
		else
		{
		   tForm.target = "_self";
		}
		
	   // RIE: navigation needs
	   // to clear the view id so it doesn't go back into the same view
      if (tForm.ViewID)
         tForm.ViewID.value = "";

      try
	  {
	      if (bPortal && parent && parent.getAnswersWorkspaceSyndicate)
	      {
	         var tSyn = parent.getAnswersWorkspaceSyndicate();
	         if (tSyn && tSyn.newWorkspaceModule(tForm.action + "&" + saw.convertFormToString(tForm)))
	            return;
	      }
	  }
      catch(e)
	  {
	  }
      
	   NQWSubmitFormWithView(tForm,tNavInfo.sViewID,null);

	}
}

// Deprecated navigation calls used by custom formatters
function GoNav(event, sPath,sTbl,sCol,sVal,sTarget)
{
	GoNavEx(event, sPath,sTarget,sTbl,sCol,sVal);
}

function NQMakeFormula(sTable, sColumn)
{
	return NQFixTableName(sTable) + "." + NQFixTableName(sColumn);
}

// Deprecated navigation calls used by custom formatters
function GoNavEx(event, sPath,sTarget,sTbl1,sCol1,sVal1,sTbl2,sCol2,sVal2,sTbl3,sCol3,sVal3,sTbl4,sCol4,sVal4)
{
	event = saw.getEvent(event);

	var tNavInfo = new NavigateInfo();

	tNavInfo.SetTargets(new Array(new Array(NQWNavReport,sPath)));
	tNavInfo.SetSearchID(GetMySearchID(saw.getEventTarget(event)));
	tNavInfo.SetViewID(GetMyViewID(saw.getEventTarget(event)));
	
	//Set the Target to the NavigateInfo Object. sTarget Value will decide to display the target reports in new window or same window.
	tNavInfo.SetIsNewWindow(sTarget);
	if(sVal1)
		tNavInfo.AddValue('eq', NQMakeFormula(sTbl1, sCol1), sVal1);
	if(sVal2)
		tNavInfo.AddValue('eq', NQMakeFormula(sTbl2, sCol2), sVal2);
	if(sVal3)
		tNavInfo.AddValue('eq', NQMakeFormula(sTbl3, sCol3), sVal3);
	if(sVal4)
		tNavInfo.AddValue('eq', NQMakeFormula(sTbl4, sCol4), sVal4);

   tNavInfo.oNavObject = tNavInfo;
	NQNavigate(event, tNavInfo);
}

// Navigation Setup Functions
function NQWNavReport(tNavSetup, tNavInfo)
{
	tNavInfo.SetReportPath(tNavSetup[1], tNavSetup[2]);
}

function NQWNavPortal(tNavSetup, tNavInfo)
{
	tNavInfo.SetPortal(tNavSetup[1], tNavSetup[2], tNavSetup[3]);
}

function NQWNavActionLink(tNavSetup, tNavInfo)
{
   tNavInfo.SetActionLink(tNavSetup[1], tNavSetup[2], tNavSetup[3], tNavSetup[4]);
}

function NQSWENav(sView, sApplet, sRowID)
{
	try
	{
//		var sURL = top._swe._sweapp.S_App.GetPageURL();
//		sURL += "?SWECmd=GotoView";
//		sURL += "&SWEView=" + saw.encodeURIComponent(sView);
//		sURL += "&SWEPostnApplet=" + saw.encodeURIComponent(sApplet);
//		sURL += "&SWEPostnRowId=" + saw.encodeURIComponent(sRowID);
//		sURL += "&SWEReloadFrames=0";

//		top._swe._sweapp.S_App.GotoURLLink(sURL, top._swe._sweapp.S_App.GetViewFrame());

//		alert(sView);
//		alert("SWEPostnApplet=" + saw.encodeURIComponent(sApplet) + "&SWEPostnRowId=" + saw.encodeURIComponent(sRowID) + "&SWEReloadFrames=0");

		top.SWEPersonalizationGotoview (sView, "SWEPostnApplet=" + saw.encodeURIComponent(sApplet) + "&SWEPostnRowId=" + saw.encodeURIComponent(sRowID) + "&SWEReloadFrames=0");
	}
	catch (e)
	{
		// Message not currently available so do nothing
		// alert(kmsgSiebelNotFound);
	}
}

function Download(sURL)
{
   // fix for CR12-1FNLAAW, saw.createHiddenIFrame() will create blank browser window in ie7.
   // fix for 5544359, DOWNLOAD TO MHTML OPENS IN THE SAME BROWSER WINDOW
   // for IE6, there will still be the blank browser window, but this is a lesser problem than opening
   // the download in the current window and lose the original page. 
   if (is_ie)
   {
      //CHANGING TO THIS FOR XP SP2 (used to create a hidden frame)
      saw.popupWindow(sURL, "_blank");
   }
   else
   {
      // SAL: For FF, the old IFRAME approach works better because the popup
      // window approach leaves empty windows open on the desktop. Ignore
      // return value because we don't need it. Note that with both approaches
      // i.e. hidden IFRAME and popup window, Moz still does not bring the
      // "download app" (IE or Excel etc.) to the foreground. This is a minor
      // annoyance that needs to be addressed.
      saw.createHiddenIFrame("sawMozDownload", null, null, sURL);
   }
}

//-------------------
function ViewBack(sViewID, sAction, sViewState)
{
	var tForm = GetViewForm(sViewID);

	tForm.StateAction.value = sViewState;
	tForm.Action.value = sAction;

   saw.submitForm(tForm,null);
   return false;
}


//**************************************88
function ModifyReport(sCmd)
{
   if (NQWIsInAnswers())
   {
      parent.location.href = sCmd;
   }
   else
   {
      if (typeof (getDashboardWorkspaceSyndicate) != 'undefined')
      {
         var tSyn = getDashboardWorkspaceSyndicate();
         if (tSyn && tSyn.newWorkspaceModule(sCmd))
            return;
      }

      window.location.href = sCmd;
   }
}

//*****************************
function GetViewParent(sViewID)
{
   if (!saw.checkObjectReference(sViewID))
      return "";

   var i = 0;
   var sTemp = sViewID;
   if (sViewID)
   {
      while (sTemp.indexOf("~") >= 0)
      {
         i += sTemp.indexOf("~");
         sTemp = sTemp.substr(sTemp.indexOf("~")+1, sTemp.length);
      }

      return sViewID.substr(0, i+1);
   }
   else
      return sViewID;
}

saw.getReloadInline = function(sViewID, sParentViewID)
{
   if (!sParentViewID)
      sParentViewID = sViewID.substr(0,sViewID.indexOf("~v:") == -1 ? sViewID.length : sViewID.indexOf("~v:"));

   var tDoneDiv = document.getElementById(getEffectiveID("EmbedView" + sParentViewID,sViewID));
   return (tDoneDiv && tDoneDiv.getAttribute("reloadInline") == "true");
}

saw.view = function()
{
}

saw.view.getRefreshStatePath = function(sViewStatePath,sViewType)
{
	// with the changes to the view id - using unique ids instead of Page 1~1
	// we need to give the exact id of the report that need refreshing
	// so in case there is one of the specific views (tableView, viewSelector, titleView)
	// and the end of the id we need to strep it out
	// another change happened and now the view could be a child of a compoundView.
   var index = sViewStatePath.indexOf("~v:compoundView");
   var sViewIdToRefresh = "";
   if(index != -1)
	   sViewIdToRefresh = sViewStatePath.substr(0,index);
   else
	{
	   index = sViewStatePath.indexOf("~v:" + sViewType);
	   if(index != -1)
		   sViewIdToRefresh = sViewStatePath.substr(0,index);
	}

	return sViewIdToRefresh;
}